package org.msh.tb.bd.tbforms.indicator.tb10;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.msh.tb.bd.tbforms.query.TbFormQuery;
import org.msh.tb.bd.tbforms.query.tb10.TBForm10Block4Query;
import org.msh.tb.entities.AdministrativeUnit;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.enums.TbFormField;
import org.msh.tb.indicators.core.Indicator2D;

import java.util.List;
import java.util.Map;

@Name("TBForm10Block4")
public class TBForm10Block4 extends Indicator2D {

    TbFormQuery formQuery;

    @In(create=true) protected Map<String, String> messages;

    @Override
    protected void createIndicators() {
        initializeInterfaceTableRows();

        Tbunit tbunit = getIndicatorFilters().getTbunitselection().getSelected();
        AdministrativeUnit adminUnit = getIndicatorFilters().getTbunitselection().getLastLevelAdminUnitSelected();

        List<Object[]> result = getFormQuery().queryDB(tbunit,
                adminUnit,
                getWorkspace(),
                getIndicatorFilters().getQuarter(),
                getEntityManager());

        for(Object[] o : result) {
            TbFormField field = (TbFormField) o[0];
            Integer qtd = (Integer) o[1];

            switch (field) {
                case TB10_BLOCK4_FIELD1:
                    addValue("M1", "M", "nodisplayname_line1", qtd.floatValue());
                    addValue(messages.get("global.total") + "1", messages.get("global.total"), "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB10_BLOCK4_FIELD2:
                    addValue("F1", "M", "nodisplayname_line1", qtd.floatValue());
                    addValue(messages.get("global.total") + "1", messages.get("global.total"), "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB10_BLOCK4_FIELD3:
                    addValue("M2", "M", "nodisplayname_line1", qtd.floatValue());
                    addValue(messages.get("global.total")+"2", messages.get("global.total"), "nodisplayname_line1", qtd.floatValue());
                    break;
                case TB10_BLOCK4_FIELD4:
                    addValue("F2", "M", "nodisplayname_line1", qtd.floatValue());
                    addValue(messages.get("global.total")+"2", messages.get("global.total"), "nodisplayname_line1", qtd.floatValue());
                    break;
            }
        }
	}

    /**
     * Initialize the interface table. All cells should be there also if it's result is zero.
     */
    private void initializeInterfaceTableRows(){
        //first 3 colummns, presumptive who had microscopy exam
        addValue("M1", "M", "nodisplayname_line1", new Float(0).floatValue());
        addValue("F1", "F", "nodisplayname_line1", new Float(0).floatValue());
        addValue(messages.get("global.total")+"1", messages.get("global.total"), "nodisplayname_line1", new Float(0).floatValue());

        //last 3 colummns, presumptive who had POSITIVE microscopy exam
        addValue("M2", "M", "nodisplayname_line1", new Float(0).floatValue());
        addValue("F2", "F", "nodisplayname_line1", new Float(0).floatValue());
        addValue(messages.get("global.total")+"2", messages.get("global.total"), "nodisplayname_line1", new Float(0).floatValue());
    }

    private TbFormQuery getFormQuery() {
        if (formQuery == null) {
            formQuery = new TBForm10Block4Query();
        }

        return formQuery;
    }
}
